<?php
// Include database connection
include('db.php'); // Assuming you have a db.php file for DB connection

// Check if the required field 'ID' is provided in the GET request
if (isset($_GET['ID'])) {

    // Get the ID value from the request and escape it to prevent SQL injection
    $ID = mysqli_real_escape_string($conn, $_GET['ID']);

    // Prepare the SQL query to update the subcategory's Delete_status
    $query = "UPDATE subcategory SET Delete_status = 1 WHERE ID = $ID";

    // Execute the query
    $result = mysqli_query($conn, $query);

    // Check if the query was successful
    if ($result) {
        // Check if any rows were affected
        if (mysqli_affected_rows($conn) > 0) {
            // Respond with a success message
            echo json_encode([
                'status' => 'success',
                'message' => 'Subcategory deleted successfully.'
            ]);
        } else {
            // If no rows were affected, return an error message
            echo json_encode([
                'status' => 'error',
                'message' => 'No subcategory found with the given ID.'
            ]);
        }
    } else {
        // Query execution failed
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to delete subcategory.',
            'error_detail' => mysqli_error($conn) // Optional: Include the error details for debugging
        ]);
    }
} else {
    // Missing required field 'ID'
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing required field: ID.'
    ]);
}

// Close the database connection
mysqli_close($conn);
?>
